// Header File
// Created 23/10/2003; 13:10:33
//Fonctions associ aux dplacements des billes...

void ChangeBillePos (unsigned char, short, short);
void AngleBille (unsigned char, unsigned char);
void ChangeBilleSpeed (unsigned char, unsigned short);

//Dimensions
#define BILLE_SIZEX				5
#define BILLE_SIZEY				5
#define BILLE_SIZEX2			4
#define BILLE_SIZEY2			4

//mode
#define BILLE_NOFIRE			0
#define BILLE_FIRE				1

//Structure BILLE
struct BILLE {
	short xpos, ypos;																	//Coordonnes de la bille
	char pcos, psin;																	//Valeur cosinus et cosinus
	short x_pcos, y_psin;															//Position absolus
		
	unsigned char rad;																//Angle de la trajectoire
	
	BOOL type;																				//Normal, FEU
	BOOL flag_shadow;																	//Active ombre
	
	char xdir, ydir;																	//Sens de dplacement de la bille
	
	//Interruption changement de vitesse
	unsigned short speed;															//Vitesse de la bille
	unsigned char speed_value;												//Coefficient de vitesse
	unsigned short counter_value;											//Counter incrmentations
	unsigned short counter_update_billepos;						//Update bille pos
	
	//Variation de vitesse
	BOOL var_speed;																		//Activation de la variation de vitesse
	unsigned long counter_varspeed;										//Compteur de variation de vitesse
	BOOL collide;																			//Collision avec briques...
	
	//Bonus Colle
	unsigned short save_speed;												//Sauvegarde la vitesse de la Bille
	unsigned char n_racket;														//Numro de la raquette
	short x_colle,y_colle;														//Coordonnes de collage
	BOOL sticked;																			//La Bille est colle								
};

struct BILLE *Bille[15];														//Structure des billes
static unsigned char nbrBille=0;
//Existance des billes
//BOOL Tbl_Billes [10];

//Variation de vitesse en fonction du temps
#define BILLES_TIMESPEED								60
unsigned short billes_counter_time;

#define VAR_SPEED												8
#define __VAR_SPEED_FREQUENCY						1028
static unsigned short __COUNTER_VARSPEED=0;

//Alloue des blocs de mmoire pour les billes.
/*void Create_BilleAllocation (void)
{
	nbrBille=0;
	memset (Tbl_Billes,0,10);
	for (int i=0;i<15;i++) Bille [i]=malloc (sizeof (struct BILLE));
}*/

//Dtruit les blocs de mmoire des billes.
void Destroy_BilleAllocation (void)
{
	for (int i=0;i<nbrBille;i++) free (Bille [i]);
}

//Intialise les donnes d'une bille
void NewBille (short x, short y, unsigned char angle, unsigned short speed, unsigned char type,unsigned char n_racket)
{
	//Dpassement de capacit
	if (nbrBille==15) return;
	
	StartInt1=FALSE;
	
	//Alloue de la mmoire pour la Bille
	Bille [nbrBille]=malloc (sizeof (struct BILLE));
	
	//Type de la bille
	Bille [nbrBille]->type=type;
	Bille [nbrBille]->flag_shadow=FALSE;
	
	//Variation de vitesse
	Bille [nbrBille]->var_speed=TRUE;
	Bille [nbrBille]->counter_varspeed=0;
	Bille [nbrBille]->collide=FALSE;
	
	//Bonus colle
	Bille [nbrBille]->sticked=FALSE;
	Bille [nbrBille]->save_speed=speed;
	
	//Appartenance
	Bille [nbrBille]->n_racket=n_racket;
	
	//Bille de feu, variation de vitesse
	if (type) Bille [nbrBille]->var_speed=FALSE;
	
	//Ajoute bille
	//Tbl_Billes [nbrBille]=TRUE;

	//Coordonnes relles et absolus
	ChangeBillePos (nbrBille, x, y);
	
	//Angle de direction
	Bille [nbrBille]->rad=angle;
	
	//Cosinus et sinus
	AngleBille (nbrBille, angle);
	
	//Vitesse de la bille
	ChangeBilleSpeed (nbrBille, speed);

	nbrBille++;
	StartInt1=TRUE;
}

//Mise  jours suivant cosinus seulement
void UpdateBillePosCos (unsigned char item)
{
	Bille [item]->x_pcos+=Bille [item]->pcos*Bille [item]->speed_value;			//v
	Bille [item]->xpos=Bille [item]->x_pcos>>7;
}

//Mise  jours suivant sinus seulement
void UpdateBillePosSin (unsigned char item)
{
	Bille [item]->y_psin+=Bille [item]->psin*Bille [item]->speed_value;			//v
	Bille [item]->ypos=Bille [item]->y_psin>>7;
}

//Mise  jours de la position d'une bille
void UpdateBillePos (unsigned char item)
{	
	UpdateBillePosCos (item);
	UpdateBillePosSin (item);
	
	Bille [item]->speed_value=0;
}

//Mise  jour de la position des billes
void UpdateBillesPos (void)
{
	for (int i=0;i<nbrBille;i++) UpdateBillePos (i);
}

//Change position d'une bille
void ChangeBillePos (unsigned char item, short x, short y)
{
	Bille [item]->xpos=x;
	Bille [item]->ypos=y;
	
	Bille [item]->x_pcos=x<<7;
	Bille [item]->y_psin=y<<7;
}

//Change la vitesse d'une bille
void ChangeBilleSpeed (unsigned char item, unsigned short speed)
{
	//Vitesse maximum
	if (speed>200) speed=200;
	
	//Arrte interruption
	StartInt1=FALSE;
	
	Bille [item]->speed=speed;
	Bille [item]->speed_value=0;
	Bille [item]->counter_value=speed*32768/255;
	Bille [item]->counter_update_billepos=0;
	
	//Restore interruption
	StartInt1=TRUE;
}


//Change l'angle de direction de la bille
void AngleBille (unsigned char item, unsigned char angle)
{
	//Modulo 2 pi
	angle&=255;
	
	Bille [item]->pcos=Tbl_pcos (angle);
	Bille [item]->psin=Tbl_psin (angle);
	Bille [item]->rad=angle;
	
	//Vecteurs de direction
	//Suivant x
	if (Bille [item]->pcos>=0) Bille [item]->xdir=1;
	else Bille [item]->xdir=-1;
	
	//Suivant y
	if (Bille [item]->psin>=0) Bille [item]->ydir=1;
	else Bille [item]->ydir=-1;
}

//Dessine les billes dans le buffer ScreenBuffer
void DrawBilles (void)
{
	for (int i=0;i<nbrBille;i++)
	{
		//Shadow
		if (Bille [i]->flag_shadow)
			//DrawSprite8_SHADOW (Bille [i]->xpos+(BILLE_SIZEX-(BILLE_SIZEX/2)),Bille [i]->ypos+(BILLE_SIZEY-(BILLE_SIZEY/2)),5,SPRITE_BILLE,ScreenBuffer);
			DrawSprite8_SHADOW (Bille [i]->xpos+3,Bille [i]->ypos+3,5,SPRITE_BILLE,ScreenBuffer);
			
		//Dessine sprite
		FastGraySprite8_MASK_R (Bille [i]->xpos, Bille [i]->ypos,5,SPRITE_BILLE,ScreenBuffer);
	}
}

//Dplacement de la bille
void MoveBille (unsigned char item, int pix)
{
	StartInt1=FALSE;
	Bille [item]->speed_value=pix;
	
	//Mise  jours position de la bille
	UpdateBillePos (item);
	StartInt1=TRUE;
}

//Efface une bille
void DeleteBille (unsigned char item)
{
	//Arrte interruption
	StartInt1=FALSE;
	
	//Libre mmoire
	free (Bille [item]);
	
	//Dplace liste de pointeurs
	memmove ((void *)(Bille+item),(void *)(Bille+item+1),(nbrBille-item-1)<<2);
	
	//Bille en moins
	nbrBille--;
	
	//Restore interruption
	StartInt1=TRUE;
}

//Efface toutes les Billes de racket item
void DeleteAllBilles (unsigned char item)
{
	//Parcours les Billes
	for (int i=0;i<nbrBille;i++)
	{
		if (Bille [i]->n_racket==item)
			DeleteBille (i--);
	}
}
